/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.sfp.addremove;

import com.ibm.hsc.auiml.databeans.sfp.addremove.AddInstallFRUBean;
import com.ibm.hsc.auiml.databeans.sfp.addremove.AddInstallHardwareConstants;
import com.ibm.hsc.ccfw.mom.PICec;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PILEDDataBean;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.websm.sfp.InstallAddRemoveHardwareTarget;
import com.ibm.hsc.websm.sfp.SFPUtil;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.FruConfig;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.FruGuiInfo;
import com.ibm.hwmca.fw.target.Target;
import com.ibm.hwmca.fw.target.TargetedTasklet;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.service.tasklet.ServiceActionDriverTasklet;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AddFRUTasklet
extends TargetedTasklet
implements AddInstallHardwareConstants {
    private static final String TRACE_MASKD = "JADFRTND";
    private static final String TRACE_MASKF = "JADFRTNF";
    private static final String TRACE_MASKT = "JADFRTNT";
    private static final String AUIML_FILE_NAME = "com.ibm.hsc.auiml.databeans.sfp.addremove.InstallAddHardware";
    private static final String INITIAL_PANEL = "AddInstallFRU1";
    private static final String SECOND_PANEL = "AddInstallFRU2";
    private static final String RV_TASKLET = "com.ibm.hwmca.xfw.service.tasklet.RepairAndVerifyTasklet";
    private static final LocalizableText BUSY_TITLE = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_FRU_TITLE");
    private static final LocalizableText BUSY_CONTENT = new LocalizableText("com.ibm.hsc.common.bundles.SFPResourceBundle", "BUSY_FRU_TEXT");
    private static final String CMD_LINE_BUNDLE = "PIHscCmdLineBundle";
    private static final String ENCL = "encl";
    private static final String SYS_TAG = "sys";
    private static final String NOT_ADDED = "not_added";
    private String userDefinedName = null;
    private ArrayList descriptionAL = null;
    private ArrayList enclosureAL = null;
    private static final short ERRID_0010 = 16;
    private static final short ERRID_0011 = 17;
    private static final short ERRID_0012 = 18;
    private static final short ERRID_0013 = 19;
    private static final short ERRID_0014 = 20;
    private static ClassLogInfo _logInfo = new ClassLogInfo(-88, -127, "SFPAddHW");

    public AddFRUTasklet() {
        Trace.trace((String)TRACE_MASKT, (Object)"<> AddFRUTasklet c-tor");
    }

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        Trace.trace((String)TRACE_MASKT, (Object)"-> AddFRUTasklet.service()");
        if (panelTaskletRequest.isInitialRequest()) {
            Trace.trace((String)TRACE_MASKF, (Object)"-> AddFRUTasklet.isInitialRequest()");
            AddInstallFRUBean addInstallFRUBean = new AddInstallFRUBean();
            addInstallFRUBean.setBeanName("AddInstallFRUBean1");
            Target[] targetArray = this.getSelectedTargets();
            String string = targetArray[0].getName().toString();
            Object object = ((InstallAddRemoveHardwareTarget)targetArray[0]).getTargetObject();
            if (object instanceof PICec) {
                this.userDefinedName = ((PICec)object).getUserDefinedName();
                Trace.trace((String)TRACE_MASKF, (Object)("-- selected system name is: " + string));
                Trace.trace((String)TRACE_MASKF, (Object)("-- userDefinedName is: " + this.userDefinedName));
                if (string != null && string.length() != 0) {
                    addInstallFRUBean.setSelectedSystem(string);
                }
                try {
                    this.showBusyDialog(BUSY_TITLE, BUSY_CONTENT);
                    this.getAllEnclosureInfo(addInstallFRUBean, this.userDefinedName);
                    String[] stringArray = addInstallFRUBean.getUniqueEnclosureLocCodes();
                    if (stringArray != null && stringArray.length > 0) {
                        String[] stringArray2 = this.getListOfEnclosureTypes(stringArray, addInstallFRUBean);
                        if (stringArray2 != null) {
                            for (int i = 0; i < stringArray2.length; ++i) {
                                Trace.trace((String)TRACE_MASKF, (Object)("unique enclosure type returned: " + stringArray2[i]));
                            }
                        } else {
                            Trace.trace((String)TRACE_MASKF, (Object)"unique enclosure type returned is null");
                        }
                        if (stringArray2 != null) {
                            addInstallFRUBean.setUniqueInstalledEnclosureTypes(stringArray2);
                        }
                    }
                    panelTaskletResponse.openModalChild(AUIML_FILE_NAME, INITIAL_PANEL, (PanelBean)addInstallFRUBean);
                    this.destroyBusyDialog();
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKD, (Object)("-- exception during initial service request, e is " + exception));
                    this.destroyBusyDialog();
                    new AusMicrocodeLog(_logInfo, 17, exception).writeEntry(null);
                    String string2 = exception.getMessage().equals("CIMNullClient") ? "0242" : (exception instanceof UnknownHostException ? "0241" : (exception instanceof PIHscClientException ? "0243" : "0245"));
                    SFPUtil.showSFPErrorMessageBox(string2, (PanelTasklet)this);
                    try {
                        panelTaskletResponse.openModalChild(AUIML_FILE_NAME, INITIAL_PANEL, (PanelBean)addInstallFRUBean);
                    }
                    catch (Exception exception2) {
                        Trace.trace((String)TRACE_MASKF, (Object)("Another exception caught during initial service request, e1 is " + exception2));
                        panelTaskletResponse.terminate();
                    }
                }
            } else {
                panelTaskletResponse.noAction();
            }
            Trace.trace((String)TRACE_MASKF, (Object)"<- AddFRUTasklet.isInitialRequest()");
        } else if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
            Trace.trace((String)TRACE_MASKF, (Object)"taskletRequest.isDisposed() or isCanceled, issue taskletResponse.dispose().");
            panelTaskletResponse.dispose();
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"-- a taskletRequest other than Cancel is pending");
            String string = (String)panelTaskletRequest.getData("cmd");
            AddInstallFRUBean addInstallFRUBean = (AddInstallFRUBean)panelTaskletRequest.getData("bean");
            Trace.trace((String)TRACE_MASKF, (Object)("command is " + string));
            if (string == null) {
                panelTaskletResponse.noAction();
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("cmd", string);
            hashMap.put("bean", addInstallFRUBean);
            if (string.equals("queryFRUs")) {
                Trace.trace((String)TRACE_MASKF, (Object)"Query FRUs request found tasklet side.");
                String string3 = (String)panelTaskletRequest.getData("data");
                try {
                    String[] stringArray = this.getValidFruTypes(string3, addInstallFRUBean);
                    hashMap.put("data", stringArray);
                    panelTaskletResponse.update(addInstallFRUBean.getBeanName(), hashMap);
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKF, (Object)("-- exception caught while querying FRUs for given enclosure, e is " + exception));
                    Trace.trace((String)TRACE_MASKF, (Object)exception);
                    panelTaskletResponse.noAction();
                }
            } else if (string.equals("populateTable")) {
                Trace.trace((String)TRACE_MASKF, (Object)"Populate location code table request found tasklet side.");
                String string4 = (String)panelTaskletRequest.getData("data");
                try {
                    this.populateFRULocCodeTable(addInstallFRUBean);
                    panelTaskletResponse.update(addInstallFRUBean.getBeanName(), hashMap);
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKF, (Object)("-- exception caught while populating the 'Available FRU' table, e is " + exception));
                    Trace.trace((String)TRACE_MASKF, (Object)exception);
                    panelTaskletResponse.noAction();
                }
            } else if (string.equals("CommitButton")) {
                Trace.trace((String)TRACE_MASKF, (Object)"Commit button found tasklet side.");
                try {
                    AddInstallFRUBean addInstallFRUBean2 = (AddInstallFRUBean)panelTaskletRequest.getData("bean");
                    this.launchRepair(panelTaskletResponse, addInstallFRUBean);
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught, e is" + exception));
                    Trace.trace((String)TRACE_MASKF, (Object)exception);
                }
            } else if (string.equals("PreviousButton")) {
                Trace.trace((String)TRACE_MASKF, (Object)"Previous button pressed");
                try {
                    PanelTaskletRequest panelTaskletRequest2 = new PanelTaskletRequest();
                    panelTaskletRequest2.setData("bean", (Object)addInstallFRUBean);
                    panelTaskletRequest2.setData("cmd", (Object)"refreshBean");
                    this.postRequest("AddInstallFRUBean1", panelTaskletRequest2);
                }
                catch (Exception exception) {
                    Trace.trace((String)TRACE_MASKF, (Object)("exception caught attempting to post a new tasklet request, e is " + exception));
                }
                panelTaskletResponse.dispose();
            } else if (string.equals("NextButton")) {
                Trace.trace((String)TRACE_MASKF, (Object)"Next button pressed");
                addInstallFRUBean.setBeanName("AddInstallFRUBean2");
                panelTaskletResponse.openModalChild(AUIML_FILE_NAME, SECOND_PANEL, (PanelBean)addInstallFRUBean);
            } else if (string.equals("refreshBean")) {
                Trace.trace((String)TRACE_MASKF, (Object)"caught the refresh command posted from 2nd dialog...");
                panelTaskletResponse.update("AddInstallFRUBean1", hashMap);
            } else {
                Trace.trace((String)TRACE_MASKT, (Object)"Unknown tasklet request sent to AddFRUTasklet.");
                panelTaskletResponse.noAction();
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- AddFRUTasklet.service()");
    }

    public void getAllEnclosureInfo(AddInstallFRUBean addInstallFRUBean, String string) throws Exception {
        block5: {
            Trace.trace((String)TRACE_MASKT, (Object)"-> AddFRUTasklet.getAllEnclosureInfo()");
            try {
                PIHSCCECClient pIHSCCECClient = this.createCECClient(string);
                if (null != pIHSCCECClient) {
                    try {
                        this.getAllSysInfo(pIHSCCECClient, addInstallFRUBean);
                        Trace.trace((String)TRACE_MASKD, (Object)"-- getAllSysInfo() completed successfully");
                        break block5;
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- exception caught during getAllSysInfo(), exception is: " + exception));
                        Trace.trace((String)TRACE_MASKF, (Object)exception);
                        new AusMicrocodeLog(_logInfo, 18, exception).writeEntry(null);
                        throw exception;
                    }
                }
                Trace.trace((String)TRACE_MASKF, (Object)"-- could not create the CEC CIM client");
                new AusMicrocodeLog(_logInfo, 19).writeEntry(null);
                throw new Exception("CIMNullClient");
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught, rethrowing..." + exception));
                new AusMicrocodeLog(_logInfo, 20, exception).writeEntry(null);
                throw exception;
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- AddFRUTasklet.getAllEnclosureInfo()");
    }

    private PIHSCCECClient createCECClient(String string) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> AddFRUTasklet.createCECClient()");
        PIHSCCECClient pIHSCCECClient = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
            Trace.trace((String)TRACE_MASKF, (Object)("-- theHostName is: " + string2));
            try {
                PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string2, null);
                String string3 = string;
                Trace.trace((String)TRACE_MASKD, (Object)("-- theSystem (selected system name) is: " + string3));
                pIHSCCECClient = pIHSCClientObjectFactory.createCECClient(string3, false);
                if (null == pIHSCCECClient) {
                    Trace.trace((String)TRACE_MASKF, (Object)"-- Cannot create PIHSCCECClient - client is null");
                    try {
                        throw new PIHscClientException("8000", CMD_LINE_BUNDLE, "MANAGED_SYSTEM_NOT_FOUND", null, null);
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- Could not throw new PIHscClientException, exception is: " + exception));
                        throw exception;
                    }
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- Exception building the r5Client is: " + exception));
                throw exception;
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- no HMC hostname, Exception is: " + unknownHostException));
            throw unknownHostException;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- AddFRUTasklet.createCECClient()");
        return pIHSCCECClient;
    }

    protected void getAllSysInfo(PIHSCCECClient pIHSCCECClient, AddInstallFRUBean addInstallFRUBean) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> AddFRUThread.getEnclosureInfo()");
        PILEDDataBean pILEDDataBean = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<Integer> arrayList5 = new ArrayList<Integer>();
        try {
            String string = addInstallFRUBean.getSelectedSystem();
            String string2 = string.substring(0, 4);
            String string3 = string.substring(5, 8);
            pILEDDataBean = pIHSCCECClient.getAllHardwareInfo();
            String[] stringArray = pILEDDataBean.getEnclosures();
            String[] stringArray2 = pILEDDataBean.getLocationCodes();
            Integer[] integerArray = pILEDDataBean.getLEDStatus();
            String string4 = null;
            int n = 0;
            ArrayList<String> arrayList6 = new ArrayList<String>();
            int n2 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(ENCL)) {
                    string4 = stringArray2[i].substring(1, 5);
                    if (string4.equals(string2)) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- system returned as an enclosure detected at index: " + i));
                    }
                    ++n;
                    arrayList5.add(new Integer(n2));
                    if (arrayList6.contains(string4)) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- duplicate enclosure found : <" + string4 + ">"));
                    } else {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- new enclosure found : <" + string4 + ">"));
                        arrayList6.add(string4);
                        arrayList3.add(new Integer(n2));
                        arrayList4.add(stringArray2[i]);
                    }
                    arrayList.add(stringArray2[i]);
                    arrayList2.add(integerArray[i]);
                    ++n2;
                } else if (stringArray[i].equals(SYS_TAG)) {
                    Trace.trace((String)TRACE_MASKF, (Object)("-- found the system identifier marker at index: " + i));
                } else {
                    arrayList.add(stringArray2[i]);
                    arrayList2.add(integerArray[i]);
                    ++n2;
                }
                Trace.trace((String)TRACE_MASKF, (Object)("locCode/status/index is <" + stringArray2[i] + "/" + integerArray[i] + "/" + i + ">"));
            }
            if (stringArray != null) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- system contains " + n + " enclosures"));
                Trace.trace((String)TRACE_MASKF, (Object)("-- system + enclosures + FRU count is " + stringArray.length));
            }
            addInstallFRUBean.setInstalledLocCodes(arrayList);
            addInstallFRUBean.setInstalledStatus(arrayList2);
            addInstallFRUBean.setUniqueEnclosureIndexes(arrayList3);
            addInstallFRUBean.setUniqueEnclosureLocCodes(arrayList4.toArray(new String[arrayList4.size()]));
            addInstallFRUBean.setAllEnclosureIndexes(arrayList5);
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- Exception invoking getAllHardwareInfo() cmd. Exception is: " + exception));
            throw exception;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- AddFRUTasklet.getEnclosureInfo()");
    }

    private String[] getListOfEnclosureTypes(String[] stringArray, AddInstallFRUBean addInstallFRUBean) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> AddFRUTasklet.determineListOfEnclosureTypes()");
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        Trace.trace((String)TRACE_MASKF, (Object)("-- input enclosureLocCodes (String[]) array size is: " + n));
        String string = addInstallFRUBean.getSelectedSystem();
        String string2 = string.substring(0, 4);
        String string3 = string.substring(5, 8);
        for (int i = 0; i < n; ++i) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- input enclosure location code[" + i + "] is <" + stringArray[i] + ">"));
        }
        Trace.trace((String)TRACE_MASKF, (Object)("-- input system type/model is " + string2 + "/" + string3));
        if (n > 0) {
            try {
                FruConfig fruConfig = new FruConfig(string2, string3);
                stringArray2 = fruConfig.queryDescriptionsByLocation(stringArray, null);
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught, e is <" + exception + ">"));
            }
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- AddFRUTasklet.determineListOfEnclosureTypes()");
        return stringArray2;
    }

    private String[] getValidFruTypes(String string, AddInstallFRUBean addInstallFRUBean) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> AddFRUTasklet.getValidFRUTypes()");
        String string2 = addInstallFRUBean.getSelectedSystem();
        String string3 = string2.substring(0, 4);
        String string4 = string2.substring(5, 8);
        Trace.trace((String)TRACE_MASKF, (Object)("-- input enclosure location code is <" + string + ">"));
        Trace.trace((String)TRACE_MASKF, (Object)("-- input system type/model is " + string3 + "/" + string4));
        String[] stringArray = null;
        try {
            FruConfig fruConfig = new FruConfig(string3, string4);
            Map map = fruConfig.queryEnclosureFruInfo(string);
            Set set = map.keySet();
            Object[] objectArray = set.toArray();
            stringArray = new String[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                stringArray[i] = (String)objectArray[i];
                Trace.trace((String)TRACE_MASKF, (Object)("-- FRU description added was <" + stringArray[i] + ">"));
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception caught, e is <" + exception + ">"));
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- AddFRUTasklet.getValidFRUTypes()");
        return stringArray;
    }

    public void populateFRULocCodeTable(AddInstallFRUBean addInstallFRUBean) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> AddInstallFRUBean.populateFRULocCodeTable");
        String[] stringArray = new String[1];
        String[] stringArray2 = new String[1];
        String[] stringArray3 = new String[1];
        String[] stringArray4 = new String[1];
        String string = null;
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        String string3 = addInstallFRUBean.getSelectedSystem();
        String string4 = string3.substring(0, 4);
        String string5 = string3.substring(5, 8);
        Trace.trace((String)TRACE_MASKF, (Object)("-- FruConfig input system type/model is " + string4 + "/" + string5));
        FruConfig fruConfig = new FruConfig(string4, string5);
        int n = addInstallFRUBean.getInstalledLocCodes().size();
        ArrayList arrayList3 = addInstallFRUBean.getAllEnclosureIndexes();
        int n2 = arrayList3.size();
        Trace.trace((String)TRACE_MASKF, (Object)("-- enclosure count to search against is " + n2));
        ArrayList arrayList4 = addInstallFRUBean.getInstalledLocCodes();
        String string6 = addInstallFRUBean.getInstalledEnclosures();
        Trace.trace((String)TRACE_MASKF, (Object)("-- enclosure type to search against is " + string6));
        boolean bl = false;
        String[] stringArray5 = null;
        String string7 = null;
        ArrayList<Object> arrayList5 = new ArrayList<Object>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        ArrayList<String> arrayList7 = new ArrayList<String>();
        for (int i = 0; i < n2; ++i) {
            Object object;
            Object object2;
            Object object3;
            String string8;
            Integer n3 = (Integer)arrayList3.get(i);
            Trace.trace((String)TRACE_MASKF, (Object)("-- enclosure index[" + i + "] value is " + n3));
            stringArray[0] = string8 = (String)arrayList4.get(n3);
            Trace.trace((String)TRACE_MASKF, (Object)("-- enclosure index[" + i + "]'s locCode is " + string8));
            try {
                stringArray5 = fruConfig.queryDescriptionsByLocation(stringArray, null);
                string7 = stringArray5[0];
                if (string7.equals(string6)) {
                    Map map = fruConfig.queryEnclosureFruInfo(string8);
                    object3 = (Collection)map.get(addInstallFRUBean.getSelectedFRU());
                    object2 = object3.iterator();
                    while (object2.hasNext()) {
                        object = (FruGuiInfo)object2.next();
                        string2 = object.getLocationSuffix();
                        arrayList.add(string2);
                        arrayList2.add(NOT_ADDED);
                        Trace.trace((String)TRACE_MASKF, (Object)("-- valid FRU suffix to add: " + string2));
                    }
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- exception e: " + exception));
                Trace.trace((String)TRACE_MASKF, (Object)exception);
            }
            if (string7.equals(string6) && n3 < n) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- current enclosure index is <" + n3 + ">"));
                block8: for (int j = n3 + 1; j < n && this.isCurrentIndexAFRU(j, addInstallFRUBean); ++j) {
                    object3 = (String)addInstallFRUBean.getInstalledLocCodes().get(j);
                    Trace.trace((String)TRACE_MASKF, (Object)("-- possible FRU locCode is: <" + (String)object3 + ">"));
                    for (int k = 0; k < arrayList.size(); ++k) {
                        if (!((String)object3).endsWith((String)arrayList.get(k))) continue;
                        object = (Integer)addInstallFRUBean.getInstalledStatus().get(j);
                        Trace.trace((String)TRACE_MASKF, (Object)("-- locCode/status of index[" + j + "] is: " + (String)object3 + "/" + object));
                        int n4 = (Integer)object & 0xC0;
                        string = n4 == 0 ? "no" : (n4 == 64 ? "yes" : "unknown");
                        arrayList7.add(string);
                        arrayList5.add(object3);
                        arrayList2.set(k, object3);
                        stringArray3[0] = object3;
                        try {
                            stringArray4 = fruConfig.queryDescriptionsByLocation(stringArray3, null);
                            if (stringArray4 == null || stringArray4.length <= 0) continue block8;
                            arrayList6.add(stringArray4[0]);
                        }
                        catch (Exception exception) {
                            Trace.trace((String)TRACE_MASKF, (Object)("-- exception caught in queryDescriptionsByLocation(), e1: " + exception));
                            arrayList6.add("unknown");
                        }
                        continue block8;
                    }
                }
                for (int j = 0; j < arrayList2.size(); ++j) {
                    if (!((String)arrayList2.get(j)).equals(NOT_ADDED)) continue;
                    arrayList7.add("unknown");
                    object2 = string8 + "-" + (String)arrayList.get(j);
                    arrayList5.add(object2);
                    Trace.trace((String)TRACE_MASKF, (Object)("-- unreported location code added: <" + (String)object2 + ">"));
                    stringArray3[0] = object2;
                    try {
                        stringArray4 = fruConfig.queryDescriptionsByLocation(stringArray3, null);
                        if (stringArray4 == null || stringArray4.length <= 0) continue;
                        arrayList6.add(stringArray4[0]);
                        continue;
                    }
                    catch (Exception exception) {
                        Trace.trace((String)TRACE_MASKF, (Object)("-- exception 2 caught in queryDescriptionsByLocation(), e2: " + exception));
                        arrayList6.add("unknown");
                    }
                }
            }
            arrayList.clear();
            arrayList2.clear();
        }
        addInstallFRUBean.setFRUTableFRULocCodes(arrayList5);
        addInstallFRUBean.setFRUTableFRUTypes(arrayList6);
        addInstallFRUBean.setFRUTableFRUStatus(arrayList7);
        Trace.trace((String)TRACE_MASKT, (Object)"<- AddInstallFRUBean.populateFRULocCodeTable");
    }

    private boolean isCurrentIndexAFRU(int n, AddInstallFRUBean addInstallFRUBean) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> AddFRUTasklet.isCurrentIndexAFRU()");
        Trace.trace((String)TRACE_MASKF, (Object)("-- input index to verify against is: " + n));
        boolean bl = true;
        ArrayList arrayList = addInstallFRUBean.getAllEnclosureIndexes();
        for (int i = 0; i < arrayList.size(); ++i) {
            Integer n2 = (Integer)arrayList.get(i);
            int n3 = n2;
            Trace.trace((String)TRACE_MASKF, (Object)("-- next enclosure index is: " + n3));
            if (n3 == n) {
                bl = false;
                Trace.trace((String)TRACE_MASKF, (Object)"-- this index is an enclosure!");
                break;
            }
            if (n3 > n) break;
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- AddFRUTasklet.isCurrentIndexAFRU()");
        return bl;
    }

    private void launchRepair(PanelTaskletResponse panelTaskletResponse, AddInstallFRUBean addInstallFRUBean) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> AddFRUTasklet.launchRepair()");
        String string = addInstallFRUBean.getSelectedSystem();
        Trace.trace((String)TRACE_MASKF, (Object)("-- input mtms data for R/V call is : " + string));
        ArrayList arrayList = addInstallFRUBean.getPendingLocCodes();
        int n = 0;
        if (arrayList != null) {
            n = arrayList.size();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)arrayList.get(i);
                Trace.trace((String)TRACE_MASKF, (Object)("-- input locCode data for R/V call is : " + stringArray[i]));
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("rvType", "MES_INSTALL_FRU");
            hashMap.put("SYSTEM_MTMS", string);
            hashMap.put("LOCATIONS", stringArray);
            Trace.trace((String)TRACE_MASKF, (Object)"AddFRUTasklet.launchRepair() launching subtasklet com.ibm.hwmca.xfw.service.tasklet.RepairAndVerifyTasklet");
            try {
                ServiceActionDriverTasklet.taskletBugMap = hashMap;
                panelTaskletResponse.redirect(RV_TASKLET, hashMap);
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- unexpected exception while launching redirect dialog, e is " + exception));
            }
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"-- pending enclosure locCode array is null");
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- AddFRUTasklet.launchRepair()");
    }

    public void logException(Throwable throwable) {
        Trace.trace((String)TRACE_MASKT, (Object)"-> AddFRUTasklet.logException()");
        Trace.trace((String)TRACE_MASKT, (Object)("processing exception: " + throwable));
        HException hException = new HException(throwable);
        new AusMicrocodeLog(_logInfo, 16, hException).writeEntry(null);
        Trace.trace((String)TRACE_MASKT, (Object)"<- AddFRUTasklet.logException()");
    }
}

